<?php include('../__functions/auth.admin.php') ?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Administrator | Change Password</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <?php @include('./layouts/styles.php'); ?>
</head>

<body class="hold-transition skin-green sidebar-mini">
    <div class="wrapper">
        <?php
            include('./layouts/header.php');
            include('./layouts/sidebar.php');
        ?>

        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <!-- Main content -->
            <section class="content">
                <div class="row">

                    <div class="col-md-12">
                        <div class="box box-success">
                            <div class="box-header with-border">
                                <h3 class="box-title"><b>Change Password</b> <i class="fa fa-lock"></i></h3>
                            </div>
                            <div class="box-body">
                                <form method="POST">
                                    <div class="row">
                                        <div class="col-md-3"></div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Old Password</label>
                                                <input type="password" name="old_password" id="old_password" class="form-control">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-3"></div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>New Password</label>
                                                <input type="password" name="new_password" id="new_password" class="form-control">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-3"></div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Confirm Password</label>
                                                <input type="password" name="confirm_password" id="confirm_password" class="form-control">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-3"></div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <button type="button" class="btn btn-md btn-block btn-info" id="change_password_btn">Change Password <i class="fa fa-edit"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
        <!-- ./wrapper -->

        <?php include('./layouts/footer.php'); ?>
    </div>
    <?php include('./layouts/scripts.php'); ?>

    <script>
        (function ($) {
            // tooltip
            $('[data-toggle="tooltip"]').tooltip();

            // manage table
            $('#example1').DataTable({
                responsive: true,
                destroy: true
            });

            // change password
            $('body').on('click', '#change_password_btn', function(){
                // collect data
                var old_password = $("#old_password").val();
                var new_password = $("#new_password").val();
                var confirm_password = $("#confirm_password").val();

                if(old_password.length < 1){
                    toastr.error("Old password field is required.");
                    return;
                }

                if(new_password.length < 1){
                    toastr.error("New password field is required.");
                    return;
                }

                if(confirm_password.length < 1){
                    toastr.error("Confirm password field is required.");
                    return;
                }

                if(confirm_password != new_password){
                    toastr.error("Confirm password does not match with New password.");
                    return;
                }

                // process
                $("#change_password_btn").attr('disabled', true).html('Updating Password.. <i class="fa fa-spinner fa-spin"></i>');
                $.ajax({
                    type:"POST",
                    url:"../__factory/UpdatePassword.php",
                    data:{old_password, new_password},
                    cache:false,
                    dataType:"json",
                    success:function(res){
                        if(res.status == 200){
                            toastr.success(res.message);
                            setTimeout(function(){
                                window.location.reload();
                            }, 2000);
                            return;
                        }else{
                            toastr.error(res.message);
                            $("#change_password_btn").attr('disabled', false).html('Change Password <i class="fa fa-edit"></i>');

                        }
                    },
                    error:function(err){
                        toastr.error(err);
                    }
                })
            });


        })(jQuery);
    </script>
</body>

</html>