<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Administrator | Login</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- Bootstrap 3.3.7 -->
    <?php include('./layouts/styles.php') ?>
</head>

<body class="hold-transition login-page">
    <div class="login-box" style="margin-top: 150px;">
        <div class="login-logo">
            <a href=""><img src="../public/backend/assets/images/lapariah.jpg" alt="LOGO" style="width: 100%;height: 117px;"></a>
        </div>
        <!-- /.login-logo -->
        <div class="login-box-body">
            <div class="alert alert-danger alert-dismissible" style="display: none;" id="error-msg-div">
                <button class="close" data-dismiss="alert">&times;</button>
                <span id="error-msg"></span>
            </div>
            <h5 class="login-box-msg"><b>NetFiber ADMIN LOGIN</b></h5>
            
            <form id="login-form" method="post" novalidate>
                <div class="form-group has-feedback">
                    <input type="email" class="form-control" id="email" name="email"
                        placeholder="Email">
                    <span class="glyphicon glyphicon-envelope form-control-feedback"></span>
                </div>
                <div class="form-group has-feedback">
                    <input type="password" class="form-control" id="password" name="password" placeholder="Password">
                    <span class="glyphicon glyphicon-lock form-control-feedback"></span>
                </div>
                <div class="row">
                    <!-- /.col -->
                    <div class="col-xs-12">
                        <button type="submit" id="submit-btn" class="btn btn-success btn-block btn-flat">Login</button>
                    </div>
                    <!-- /.col -->
                </div>
            </form>
        </div>
        <!-- /.login-box-body -->
    </div>
    <!-- /.login-box -->

    <?php include('./layouts/scripts.php'); ?>
    <script>
        (function ($) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            // jquery validator validate email
            $.validator.addMethod('is_email', function (value, element) {
                var re = /^\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/
                return this.optional(element) || re.test(value);
            }, "please enter a valid email address.");
            
            $('#login-form').validate({
                rules: {
                    email: { required: true, email: true, is_email: true },
                    password: { required: true }
                },
                messages: {
                    email: { required: "The Email field is required." },
                    password: { required: "The Password field is required." }
                },
                onblur: true,
                onfocus: true,
                errorClass: "help-block",
                errorElement: "strong",
                highlight: function(element) {
                    $(element).closest('.form-group').addClass('has-error').removeClass('has-success');
                },
                unhighlight: function(element) {
                    $(element).closest('.form-group').addClass('has-success').removeClass('has-error');
                },
                errorPlacement: function(error, element) {
                    if (element.parent('.input-group').length) {
                        error.insertAfter(element.parent())
                        return false;
                    } else {
                        error.insertAfter(element);
                        return false;
                    }
                },
                submitHandler: function () {
                    event.preventDefault();
                    
                    var email = $('#email').val();
                    var password = $('#password').val();
                    $('#submit-btn').attr('disabled', true).html('Please wait...');

                    $.ajax({
                        url: "../__factory/AdminLogin.php",
                        type: "POST",
                        data: {
                            email: email,
                            password: password
                        },
                        dataType: 'json',
                        cache: false,
                        success: function (response) {
                            if (response.status == 200) {
                                setTimeout(() => {
                                    toastr.success(response.message);
                                }, 2000);
                                
                                window.location.href = response.location;
                            } else {
                                toastr.error(response.message);
                                $('#submit-btn').attr('disabled', false).html('Login');
                            }
                        }
                    });

                    return false;
                }
            });
        })(jQuery);
    </script>
</body>
</html>