<?php include('../__functions/auth.admin.php') ?>
<?php include('../__factory/FetchCustomerData.php') ?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Administrator | Home</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <?php @include('./layouts/styles.php'); ?>
</head>

<body class="hold-transition skin-green sidebar-mini">
    <div class="wrapper">
        <?php
            include('./layouts/header.php');
            include('./layouts/sidebar.php');
        ?>

        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <!-- Main content -->
            <section class="content">
                <div class="row">
                    <!-- ./col -->
                    <?php if($_SESSION['user_type'] == 'admin'){ ?>
                        <div class="col-lg-3 col-xs-12">
                            <!-- small box -->
                            <div class="small-box bg-aqua">
                                <div class="inner">
                                    <h3 id="total_customers"><?php echo count($data['records']) ?></h3>
                                    <p>Total Customers <i class="fa fa-users fa-2x"></i></p>
                                </div>
                                <div class="icon">
                                    <i class="ion ion-music"></i>
                                </div>
                            </div>
                        </div>
                    <?php } ?>

                    <!-- ./col -->
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <div class="box box-success">
                            <div class="box-header with-border">
                                <h3 class="box-title"><b>Manage Customers</b></h3>
                                <a href="#" class="btn btn-success btn-sm pull-right" data-toggle="modal" data-target="#payment_config_modal">Configure Payment <i class="fa fa-cog"></i></a>
                            </div>
                            <div class="box-body">
                                <div class="table-responsive">
                                    <table id="example1"
                                        class="table table-condensed table-striped table-hover table-bordered"
                                        style="width: 100%;">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Image</th>
                                                <th>Full Name</th>
                                                <th>Email</th>
                                                <th>Phone</th>
                                                <th>Business Name</th>
                                                <th>Amount Paid</th>
                                                <th>Status</th>
                                                <th>Date</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php 
                                                $sn =1;
                                                foreach($data['records'] as $list){ 
                                            ?>
                                                <tr>
                                                    <td><?php echo $sn++; ?></td>
                                                    <td>
                                                        <a href="../public/<?php echo($list['image_url']) ?>" target="_blank"><img src="../public/<?php echo($list['image_url']) ?>" class="img-responsive img-thumbnail" style="object-fit: contain;width:200px;">
                                                        </a>
                                                    </td>
                                                    <td>
                                                        <?php echo strtoupper($list['fullname']); ?>
                                                    </td>
                                                    <td>
                                                        <?php echo strtoupper($list['email']); ?>
                                                    </td>
                                                    <td>
                                                        <?php echo ($list['phone']); ?>
                                                    </td>
                                                    <td>
                                                        <?php echo strtoupper($list['business_name']); ?>
                                                    </td>
                                                    <td>
                                                        <?php echo number_format($list['amount']); ?>
                                                    </td>
                                                    <td>
                                                        <?php if($list['status']== 'pending'){ ?>
                                                            <i class="label label-warning">Pending</i>
                                                        <?php }else if($list['status']== 'verified'){ ?>
                                                            <i class="label label-success">Verified</i>
                                                        <?php }else{ ?>
                                                            <i class="label label-danger">Payment not received</i>
                                                        <?php } ?>
                                                    </td>
                                                    <td>
                                                        <?php echo ($list['created_at']); ?>
                                                    </td>
                                                    <td style="width: 260px;">
                                                        <div class="btn-group" role="group">
                                                            
                                                            <?php if($list['status']== 'pending'){ ?>
                                                               <a href="javascript:void(0);" class="btn btn-success btn-xs process_status" customer_id="<?php echo($list['id']); ?>" mode="verify">Verify Payment <i class="fa fa-check"></i></a>

                                                               <a href="javascript:void(0);" class="btn btn-danger btn-xs not_received" customer_id="<?php echo($list['id']); ?>"> Payment not received <i class="fa fa-times"></i></a>
                                                            <?php }else{ ?>
                                                                <a href="javascript:void(0);" class="btn btn-warning btn-xs process_status" customer_id="<?php echo($list['id']); ?>" mode="revert">Revert Verification <i class="fa fa-times"></i></a>
                                                            <?php } ?>
                                                            <!-- <a href="print-customer-details.php?customer_id=<?php //echo($list['id']); ?>" class="btn btn-info btn-xs">Print <i class="fa fa-print"></i></a> -->
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php  } ?>

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
        <!-- ./wrapper -->

        <!-- modal -->
        <div class="modal center-modal fade" id="payment_config_modal" tabindex="-1">
            <div class="modal-dialog">
              <div class="modal-content">
                <div class="modal-header">
                <h3 class="modal-title">Payment Fee Config<i class="fa fa-money"></i></h3>
                <button type="button" class="close" data-dismiss="modal">
                  <span aria-hidden="true">&times;</span>
                </button>
                </div>
                <form id="payment_fee_form" method="POST">
                    <div class="modal-body">
                            <div class="row">
                                <div class="col-md-2"></div>
                                <div class="col-md-8">
                                    <div class="form-group">
                                        <label for="" class="control-label">Full Payment Amount</label>
                                        <input type="number" name="amount" id="amount" value="<?php echo($data['reg_fee']) ?>" class="form-control" required>
                                    </div>

                                    <div class="form-group">
                                        <label for="" class="control-label">Early Bird Amount</label>
                                        <input type="number" name="early_bird_fee" id="early_bird_fee" value="<?php echo($data['early_bird_fee']) ?>" class="form-control" required>
                                    </div>

                                    <div class="form-group">
                                        <label for="" class="control-label">Payment Type</label>
                                        <select class="form-control" name="payment_type" id="payment_type" required>
                                            <option value="">--select--</option>
                                            <option value="reg_fee" <?php echo ($data['payment_type'] == 'reg_fee')?'selected':'' ?>>Gate Fee</option>
                                            <option value="early_bird" <?php echo ($data['payment_type'] == 'early_bird')?'selected':'' ?>>Early Bird</option>
                                        </select>
                                    </div>

                                    <div class="form-group">
                                        <label for="" class="control-label">Bank Name</label>
                                        <input type="text" name="bank_name" id="bank_name" value="<?php echo($data['bank_name']) ?>" class="form-control" required>
                                    </div>

                                    <div class="form-group">
                                        <label for="" class="control-label">Early Bird Amount</label>
                                        <input type="number" name="account_no" id="account_no" value="<?php echo($data['account_no']) ?>" class="form-control" required>
                                    </div>

                                    <div class="form-group">
                                        <label for="" class="control-label">Early Bird Amount</label>
                                        <input type="text" name="account_name" id="account_name" value="<?php echo($data['account_name']) ?>" class="form-control" required>
                                    </div>
                                </div>
                                <div class="col-md-2"></div>
                            </div>
                    </div>
                    <div class="modal-footer modal-footer-uniform">
                        <button type="submit" id="update_btn" class="btn btn-rounded btn-info float-right">Update <i class="fa fa-money"></i></button>
                        <button type="button" class="btn btn-rounded btn-secondary" data-dismiss="modal">Close</button>
                    </div>
                </form>
              </div>
            </div>
        </div>
        <!-- // modal -->
        <?php include('./layouts/footer.php'); ?>
    </div>
    <?php include('./layouts/scripts.php'); ?>

    <script>
        (function ($) {
            // manage table
            $('#example1').DataTable({
                responsive: true,
                destroy: true
            });


            $("#payment_fee_form").on('submit', function(e){
                e.preventDefault()
                // collect data
                let amount =  $('#amount').val();
                let early_bird_fee =  $('#early_bird_fee').val();
                let payment_type =  $('#payment_type').val();
                let bank_name =  $('#bank_name').val();
                let account_no =  $('#account_no').val();
                let account_name =  $('#account_name').val();

                if(amount.length < 1 || ins_amount.length < 1){
                    toastr.error('Both/fields are required');
                    return;
                }

                // process
                $.ajax({
                    type:"POST",
                    url:"../__factory/web.php?route=updateRegFee",
                    data:{
                        amount:amount,
                        early_bird_fee:early_bird_fee,
                        payment_type:payment_type,
                        bank_name:bank_name,
                        account_no:account_no,
                        account_name:account_name
                    },
                    cache:false,
                    dataType:"json",
                    success:function(res){
                        if(res.status == 200){
                            toastr.success(res.message);
                            setTimeout(function(){
                                window.location.reload();
                            }, 2000);
                        }else{
                            toastr.error(res.message);
                        }
                    },
                    error: function(err){
                        console.log('errFee', err);
                    }
                })
            });

            $(".process_status").on('click', function(){
                // collect data
                let el= this;
                let customer_id =  $(el).attr('customer_id');
                let mode =  $(el).attr('mode');

                let confirmReq = confirm(`Are you sure you want to ${mode.toUpperCase() } this payment?.`);

                if(!confirmReq){
                    return;
                }


                // processtoggleCusStatus
                $.ajax({
                    type:"POST",
                    url:"../__factory/web.php?route=toggleCusStatus",
                    data:{
                        customer_id:customer_id
                    },
                    cache:false,
                    dataType:"json",
                    success:function(res){
                        if(res.status == 200){
                            toastr.success(res.message);
                            setTimeout(function(){
                                window.location.reload();
                            }, 2000);
                        }else{
                            toastr.error(res.message);
                        }
                    },
                    error: function(err){
                        console.log('errFee', err);
                    }
                })
            });

            $(".not_received").on('click', function(){
                // collect data
                let el= this;
                let customer_id =  $(el).attr('customer_id');

                let confirmReq = confirm(`Are you sure you want to mark this payment as not received?.`);

                if(!confirmReq){
                    return;
                }


                // processtoggleCusStatus
                $.ajax({
                    type:"POST",
                    url:"../__factory/web.php?route=cusPaymentNotReceived",
                    data:{
                        customer_id:customer_id
                    },
                    cache:false,
                    dataType:"json",
                    success:function(res){
                        if(res.status == 200){
                            toastr.success(res.message);
                            setTimeout(function(){
                                window.location.reload();
                            }, 2000);
                        }else{
                            toastr.error(res.message);
                        }
                    },
                    error: function(err){
                        console.log('errFee', err);
                    }
                })
            });
            
        })(jQuery);
    </script>
</body>

</html>