<?php
require_once('../__config/connect.php');

class ManageCustomer extends DbConnection
{
    /**
     * @var $connection
     */
    protected $plug;

    public function __construct()
    {
        $this->plug = DbConnection::connect();
    }

    /**
    * get all record
    */
    public function getAllRecords(){
        // fetch all records
        $getRecordSql= "SELECT * FROM customers ORDER BY id DESC";
        $getRecords = mysqli_query($this->plug, $getRecordSql);


        // set arrays
        $dataArr = [];

        while ($row = mysqli_fetch_assoc($getRecords)) {
            # code...
            array_push($dataArr, $row);
        }

        // fetch config price
        $getFetch =  mysqli_query($this->plug, "SELECT * FROM configs");
        $getFeeData = mysqli_fetch_assoc($getFetch);

        $reg_fee = $getFeeData['reg_fee'];
        $early_bird_fee = $getFeeData['early_bird_fee'];

        return [
            'records'=> $dataArr,
            'reg_fee'=> $reg_fee,
            'early_bird_fee'=> $early_bird_fee,
            'bank_name'=> $getFeeData['bank_name'],
            'account_no'=> $getFeeData['account_no'],
            'account_name'=> $getFeeData['account_name'],
            'payment_type'=> $getFeeData['payment_type']
        ];
    }

}

// get all records
$getRecords = new ManageCustomer();
$data  = $getRecords->getAllRecords();

