<?php

require_once('../__config/connect.php');
session_start();

// include mailer
include('../mail/PHPMailerAutoload.php');


class AdminController extends DbConnection
{
    /**
     * @var $plug
     */
    protected $plug;

    public function __construct()
    {
        $this->plug = DbConnection::connect();
    }


    /**
    * send mail
    */
    public function sendMailNotice($payload){
        $mail = new PHPMailer;
        $mail->isSMTP();                                      
        $mail->Host = "mail.rayscorner.com.ng";
        $mail->SMTPAuth = true;                           
        $mail->Username = 'events@rayscorner.com.ng';
        $mail->Password = 'P@$$w0rd-12';                          
        $mail->SMTPSecure = 'ssl';                            
        $mail->Port = 465;
        $mail->setFrom('events@rayscorner.com.ng', 'Event');
        $mail->FromName ='Kubwa Events';             
        $mail->addAddress($payload['email'] , $payload['fullname']);              
        $mail->isHTML(true);                                 

        $mail->Subject = $payload['subject'];
        $mail->Body    = $payload['message'];

        // $mail->SMTPDebug =  1;
        if($mail->send()) {
            return ['error'=>false, 'message'=> 'mail sent'];
        }else{
            return ['error'=>true, 'message'=>'could not send mail'];
        }
    }

    /**
     * Login administrator
     * @param  String $email
     * @param  String $password
     */
    public function login($email, $password)
    {
        $email =  trim($email);
        $password = trim(htmlentities($password));
        
        // Check if administrator is valid
        $sql = "SELECT * FROM `users` WHERE `email` = '" . $email . "' AND `password` = '" . $password . "' AND status='active' LIMIT 1";

        // Validate details
        $validateAdminDetails = mysqli_query($this->plug, $sql);
        $result = mysqli_num_rows($validateAdminDetails);
        if ($result == 1) {
            $row = mysqli_fetch_assoc($validateAdminDetails);
            $_SESSION['email'] = $row['email'];
            $_SESSION['fullname'] = $row['fullname'];
            $_SESSION['user_id'] = $row['id'];
            $_SESSION['user_type'] = $row['user_type'];
            $_SESSION['admin'] =  $row['id'];
            echo json_encode(['status' => 200, 'message' => 'Login successful.', 'location' => 'home.php']);
        } else {
            echo json_encode(['status' => 401, 'message' => 'Invalid Email/Password provided.']);
        }
    }

    /**
    * update admin password
    */
    public function updatePassword($old_password, $new_password)
    {
        // Check if administrator is valid
        $sql = "SELECT * FROM `users` WHERE `email` = '" . $_SESSION['email'] . "' AND `password` = '" . $old_password . "' LIMIT 1";

        // Validate details
        $validateAdminDetails = mysqli_query($this->plug, $sql);
        $result = mysqli_num_rows($validateAdminDetails);
        if ($result == 1) {
            // update password
            $update = "UPDATE `users` SET `password` = '$new_password' WHERE email='".$_SESSION['email']."'";

            if(mysqli_query($this->plug, $update)){
                // activity log
                    $activity_user= $_SESSION['user_id'];
                    $activity = 'Changed password';
                    $saveActivity = "INSERT INTO activity_logs(user_id, activity) VALUES ('$activity_user', '$activity')";
                    mysqli_query($this->plug, $saveActivity);
                # end activity log

                echo json_encode(['status'=> 200, 'message'=> 'Password updated successfully.']);
                exit();
            }
            # activity log
                $activity_user= $_SESSION['user_id'];
                $activity = 'Tried to change password';
                $saveActivity = "INSERT INTO activity_logs(user_id, activity) VALUES ('$activity_user', '$activity')";
                mysqli_query($this->plug, $saveActivity);
            # end activity log

            echo json_encode(['status'=> 203, 'message'=> 'Failed to update password.']);
            exit();
        }

        echo json_encode(['status'=> 203, 'message'=> 'Incorrect old password supplied.']);
        exit();
    }

    /**
    * update the reg fee
    */
    public function updateRegFee()
    {
        extract($_POST);

        // update fee
        $updateSql=  "UPDATE configs SET reg_fee='$amount', early_bird_fee='$early_bird_fee', payment_type='$payment_type', bank_name='$bank_name', account_no='$account_no', account_name='$account_name' ";

        if(mysqli_query($this->plug, $updateSql)){
            echo json_encode(["status"=>200, "message"=>"Registration fee updated successfully."]);
            exit();
        }

        echo json_encode(["status"=>200, "message"=>"Failed! could not update registration fee."]);
        exit();
    }

    /**
    * toggle customer status
    */
    public function toggleCustomerStatus($customer_id)
    {
        // get record
        $getCusRecord = mysqli_query($this->plug, "SELECT * FROM customers WHERE id='$customer_id'");

        if(mysqli_num_rows($getCusRecord) < 1){
            echo json_encode(["status"=>203, "message"=> "Failed! Could not update customer status"]);
            exit();
        }

        // collect data
        $customer = mysqli_fetch_assoc($getCusRecord);

        // check status
        $updateSql="UPDATE customers SET status='pending' WHERE id='$customer_id' ";
        if($customer['status'] == 'pending'){
            $updateSql="UPDATE customers SET status='verified' WHERE id='$customer_id' ";
        }

        if(mysqli_query($this->plug, $updateSql)){
            if($customer['status'] == 'pending'){
                // send mail with ticket
                $payload = [
                    "subject"=>"Payment Successful",
                    "message"=>"<!DOCTYPE html>
                    <html>
                    <head>
                        <title></title>
                    </head>
                    <body>
                            <img alt='ticket' src='http://events.rayscorner.com.ng/public/even_ticket.jpeg' >
                    </body>
                    </html>",
                    "email"=>$customer['email'],
                    "fullname"=>$customer['fullname']
                ];

                $this->sendMailNotice($payload);
            }

            echo json_encode(["status"=>200, "message"=> "Customer payment status updated successfully."]);
            exit();
        }
        echo json_encode(["status"=>203, "message"=> "Failed! Could not verify customer status"]);
        exit();
    }

    /**
    *  customer payment not received
    */
    public function cusPaymentNotReceived($customer_id)
    {
        // get record
        $getCusRecord = mysqli_query($this->plug, "SELECT * FROM customers WHERE id='$customer_id'");

        if(mysqli_num_rows($getCusRecord) < 1){
            echo json_encode(["status"=>203, "message"=> "Failed! Could not process data."]);
            exit();
        }

        // collect data
        $customer = mysqli_fetch_assoc($getCusRecord);

        // check status
        $updateSql="UPDATE customers SET status='not_verified' WHERE id='$customer_id' ";
        
        if(mysqli_query($this->plug, $updateSql)){
            // send payment not Received mail
            $payload = [
                "subject"=>"No payment received!",
                "message"=>'<p>Payment not received.</p>',
                "email"=>$customer['email'],
                "fullname"=>$customer['fullname']
            ];

            $this->sendMailNotice($payload);
            echo json_encode(["status"=>200, "message"=> "Customer payment status updated successfully."]);
            exit();
        }
        echo json_encode(["status"=>203, "message"=> "Failed! Could not verify customer status"]);
        exit();
    }    
}